<?php
/***************************************************************************
*                               admin_ignore.php
*                              -------------------
*     begin                : Mon Sep 27, 2004
*     copyright            : (c) 2004 Phillip Pollard
*     email                : phil@crescendo.net
*
****************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

$cred = '<a target="_top" href="http://www.crescendo.net/software/phpbb-ignore">User Ignore Mod</a><br />v1.2.1 &copy; 2004 by Bennie<br />v1.1.1 &copy; 2002 by GunnerX and The phpBB Group';

define('IN_PHPBB', 1);

if( !empty($setmodules) ) {
  $filename = basename(__FILE__);
  $module['Users']['Ignore Stats'] = $filename;
  return;
}

//
// Load default header
//

$no_page_header = TRUE;
$phpbb_root_path = './../';
require($phpbb_root_path . 'extension.inc');
require('./pagestart.' . $phpEx);

//
// Raw Dump
//

if ( isset($HTTP_GET_VARS['mode']) || isset($HTTP_POST_VARS['mode']) ) {
  $mode = ($HTTP_GET_VARS['mode']) ? $HTTP_GET_VARS['mode'] : $HTTP_POST_VARS['mode'];
}

if ( $mode == 'raw' ) {
  include('./page_header_admin.'.$phpEx);
  $template->set_filenames(array( 'body' => 'admin/ignore_full.tpl' ));
  $template->assign_vars(array(
    'L_CREDS'  => $cred,
    'L_IGNORE' => $lang['ig_ignore'],
    'L_USER'   => $lang['ig_user'],
    'L_IGNORE_TITLE' => $lang['ig_raw_ignore_title'],
    'L_IGNORE_TEXT'  => $lang['ig_raw_ignore_text']
  ));
  $sql = 
    'select a.username as user, c.username as ignoring from '.USERS_TABLE.' a, '
    .IGNORE_TABLE. ' b, '.USERS_TABLE.' c where a.user_id = b.user_id and '
    .'b.user_ignore = c.user_id order by a.username, c.username';

  if( !$result = $db->sql_query($sql) ) {
    message_die(GENERAL_ERROR, "Could not query words table", $lang['Error'], __LINE__, __FILE__, $sql);
  }

  while ( $row = $db->sql_fetchrow($result) ) {
    $row_color = ( !($i % 2) ) ? $theme['td_color1'] : $theme['td_color2'];
    $row_class = ( !($i % 2) ) ? $theme['td_class1'] : $theme['td_class2'];

    $template->assign_block_vars('ignore', array(
                          "ROW_COLOR" => "#" . $row_color,
                          "ROW_CLASS" => $row_class,
                          'USER' => $row['user'],
                          'IGNORING' => $row['ignoring']
    ));
  }

  $template->pparse('body');

  include('./page_footer_admin.'.$phpEx);
  return;
}

//
// Generate page
//

include('./page_header_admin.'.$phpEx);

$template->set_filenames(array(
        'body' => 'admin/ignore.tpl')
);

$template->assign_vars(array(
  'L_IGNORE_TITLE'   => $lang['ignore_title'],
  'L_IGNORE_TEXT'    => $lang['ignore_text'],
  'L_IGNORED_TITLE'  => $lang['ignored_title'],
  'L_IGNORED_TEXT'   => $lang['ignored_text'],
  'L_IGNORING_TITLE' => $lang['ignoring_title'],
  'L_IGNORING_TEXT'  => $lang['ignoring_text'],

  // Section heads

  'L_COUNT'     => $lang['ig_count'],
  'L_USER'      => $lang['ig_user'],
  'L_IGNORE'    => $lang['ig_ignore'],
  'L_IGNORES'   => $lang['ig_ignores'],
  'L_IGNORING'  => $lang['ig_ignoring'],
  'L_IGNORE_BY' => $lang['ig_ignore_by'],

  // Misc

  'L_RAW_TEXT' => $lang['ig_raw_text'],
  'L_RAW_HREF' => append_sid("admin_ignore.$phpEx?mode=raw"),
  'L_RAW_LINK' => $lang['ig_raw_link'],

  'L_CREDS' => $cred
));

//
// Snag the details
//

// Top 10 ignored folks

$sql = 'select count(*) as count, a.user_id, a.username from ' . USERS_TABLE
     . ' a, ' . IGNORE_TABLE . ' b where a.user_id = b.user_ignore '
     . 'group by b.user_ignore order by count desc, username limit 10';

if( !$result = $db->sql_query($sql) ) {
  message_die(GENERAL_ERROR, "Could not query ignore table", $lang['Error'], __LINE__, __FILE__, $sql);
}

while ( $row = $db->sql_fetchrow($result) ) {
  $row_color = ( !($i % 2) ) ? $theme['td_color1'] : $theme['td_color2'];
  $row_class = ( !($i % 2) ) ? $theme['td_class1'] : $theme['td_class2'];

  $sql = 'select a.username from ' . USERS_TABLE . ' a, ' . IGNORE_TABLE 
       . ' b where a.user_id = b.user_id and b.user_ignore = ' 
       . $row['user_id'];

  if( !$sub_result = $db->sql_query($sql) ) {
    message_die(GENERAL_ERROR, "Could not query ignore table", $lang['Error'], __LINE__, __FILE__, $sql);
  }

  $users = array();
  while ( $subrow = $db->sql_fetchrow($sub_result) ) {
   $users[] = $subrow['username'];
  }

  $template->assign_block_vars('top_ignored', array(
                        "ROW_COLOR"  => "#" . $row_color,
                        "ROW_CLASS"  => $row_class,
                        'COUNT'      => $row['count'],
                        'USER'       => $row['username'],
                        'IGNORED_BY' => join(', ', $users)
  ));


}

// Top 10 ignoring folks

$sql = 'select count(*) as count, a.user_id, a.username from ' . USERS_TABLE
     . ' a, ' . IGNORE_TABLE . ' b where a.user_id = b.user_id '
     . 'group by b.user_id order by count desc, username limit 10';

if( !$result = $db->sql_query($sql) ) {
  message_die(GENERAL_ERROR, "Could not query ignore table", $lang['Error'], __LINE__, __FILE__, $sql);
}

while ( $row = $db->sql_fetchrow($result) ) {
  $row_color = ( !($i % 2) ) ? $theme['td_color1'] : $theme['td_color2'];
  $row_class = ( !($i % 2) ) ? $theme['td_class1'] : $theme['td_class2'];

  $sql = 'select a.username from ' . USERS_TABLE . ' a, ' . IGNORE_TABLE 
       . ' b where a.user_id = b.user_ignore and b.user_id = '
       . $row['user_id'];

  if( !$sub_result = $db->sql_query($sql) ) {
    message_die(GENERAL_ERROR, "Could not query ignore table", $lang['Error'], __LINE__, __FILE__, $sql);
  }

  $users = array();
  while ( $subrow = $db->sql_fetchrow($sub_result) ) {
   $users[] = $subrow['username'];
  }

  $template->assign_block_vars('top_ignoring', array(
                        "ROW_COLOR"  => "#" . $row_color,
                        "ROW_CLASS"  => $row_class,
                        'COUNT'      => $row['count'],
                        'USER'       => $row['username'],
                        'IGNORING'   => join(', ', $users)
  ));
}

// Fin

$template->pparse('body');
include('./page_footer_admin.'.$phpEx);

?>
